function showAxisDialog(id, options) {
    var height = 400;
    var width = 600;
    var heightPercent = 0;
    var widthPercent = 0;
    var cssClass = "";
    var href = "";
    var content = "";
    var placeholderDiv = "";
    var title;
    var iconUrl = "";

    var showTitleBar = true;
    var showWindowFrame = true;
    var showLoader = true;
    var showCloseX = true;
    var destroyOnClose = true;
    var reloadOnOpen = false;
    var disableIframeScrolling = false;
    var escapeToClose = true;

    var modal = true;
    var modalClickClosesDialog = false;

    var resize = false;
    var resizeMinHeight = 400;
    var resizeMinWidth = 600;
    var move = false;
    var maximize = false;
    var maximized = false;
    var minimize = false;
    var pinToCenterOnResize = true;
    var ieInputBoxFix = null;
    var onClose = "";
    var onShow = "";
    var onDestroy = "";
    var onFrameLoad = "";
    var onFrameReload = "";

    if (typeof zIndex === "undefined") zIndex = 100000;

    if (options) {
        if (options.height != null) { height = options.height; resizeMinHeight = options.height; } //integer
        if (options.width != null) { width = options.width; resizeMinWidth = options.width; }  //integer
        if (options.heightPercent != null) heightPercent = options.heightPercent; //integer 0 to 100
        if (options.widthPercent != null) widthPercent = options.widthPercent; //integer 0 to 100
        if (options.href != null) href = options.href; //string; href to call as an iframe
        if (options.onClose != null) onClose = options.onClose; //callback function like function(window) { } when closing the window
        if (options.onShow != null) onShow = options.onShow; //callback function like function(window) { } when showing the window
        if (options.onDestroy != null) onDestroy = options.onDestroy; //callback function like function(window) { } when DESTROYING the window
        if (options.onFrameLoad != null) onFrameLoad = options.onFrameLoad; //callback function like function(window, dialog) { } for onload in the iframe
        if (options.onFrameReload != null) onFrameReload = options.onFrameReload; //callback function like function(window, dialog) { } for onload in the iframe
        /* example
        onFrameReload: function(iframe, dialogBox) {       
        document.getElementById($j(iframe).attr("id")).contentWindow.setTimeout("FunctionToRunInIFrame(args);", 0);
        } 
        */
        if (options.showCloseX != null) showCloseX = options.showCloseX; //bool; shows the close X in the corner IF showTitleBar == true 
        if (options.modalClickClosesDialog != null) modalClickClosesDialog = options.modalClickClosesDialog; //bool; clicking the background overlay closes the window if modal == true
        if (options.destroyOnClose != null) destroyOnClose = options.destroyOnClose; //bool, destroy the whole object on close
        if (options.reloadOnOpen != null) reloadOnOpen = options.reloadOnOpen; //bool, reload the iframe on load IF destroyOnClose == false
        if (options.resize != null) resize = options.resize; //bool
        if (options.resizeMinHeight != null) resizeMinHeight = options.resizeMinHeight; //integer
        if (options.resizeMinWidth != null) resizeMinWidth = options.resizeMinWidth;  //integer
        if (options.move != null) move = options.move; //bool
        if (options.content != null) content = options.content; //html
        if (options.placeholderDiv != null) placeholderDiv = options.placeholderDiv; //id of placeholder div to get content from
        if (options.title != null) title = options.title; //string  
        if (options.iconUrl != null) iconUrl = options.iconUrl; //string  
        if (options.pinToCenterOnResize != null) pinToCenterOnResize = options.pinToCenterOnResize; //bool  
        if (options.modal != null) modal = options.modal; //bool
        if (options.showTitleBar != null) showTitleBar = options.showTitleBar; //bool
        if (options.showWindowFrame != null) showWindowFrame = options.showWindowFrame; //bool
        if (options.showLoader != null) showLoader = options.showLoader; //bool; shows "Loading..." title and icon while iframe href is loading
        if (options.cssClass != null) cssClass = options.cssClass; //string; append to wrapper classes for targeting
        if (options.maximize != null) maximize = options.maximize; //bool; show the maximize button in the actions bar
        if (options.maximized != null) maximized = options.maximized; //bool; maximize on load
        if (options.minimize != null) minimize = options.minimize; //bool; show the minimize button in the actions bar 
        if (options.disableIframeScrolling != null) disableIframeScrolling = options.disableIframeScrolling; //bool; no scrolling on iframe
        if (options.escapeToClose != null) escapeToClose = options.escapeToClose; //bool; no scrolling on iframe
    }
    if (heightPercent != 0) height = $j(window).height() * (heightPercent / 100);
    if (widthPercent != 0) width = $j(window).width() * (widthPercent / 100);

    if (iconUrl === "" && href.indexOf("https:///") !== -1) iconUrl = "../secure.clubessential.com/A_master/images/lock.png";

    if (placeholderDiv != "") {
        content = $j("#" + placeholderDiv).html();
        $j("#" + placeholderDiv).remove();
    }
    var isMobile = false;
    try {
        if (getCookie("LoadingAsMobile") == "true" || axisBrowser().IsMobile || axisBrowser().IsTablet) isMobile = true;
        if (getCookie("LoadingAsMobile") != "true" && axisBrowser().IsTablet) isMobile = false;
    } catch (e) {
        if (navigator.userAgent.indexOf("CEMOSV SIMULATOR") >= 0) isMobile = true;
    }
    if (isMobile) {
        resize = false;
        move = false;
        maximize = false;
        maximized = false;
        pinToCenterOnResize = false;
        modal = false;
        minimize = false;
        escapeToClose = false;
    }

    if ($j("#" + id).length > 0) {
        if (reloadOnOpen && content == "") {
            $j("#" + id + "iframe").attr("src", href);
        }
        $j("#" + id).trigger("show");
        if (onFrameReload) {
            $j("#" + id + "iframe").show(onFrameReload($j("#" + id + "iframe"), dialogBox));
        }
        return;
    }

    if (cssClass != "") cssClass = " " + cssClass;

    var initialHeight = (content != "" || !showLoader) ? height : 200;
    var initialWidth = (content != "" || !showLoader) ? width : 200;

    var left = ($j(window).width() / 2) - (initialWidth / 2);
    var top = ($j(window).height() / 2) - (initialHeight / 2);

    if (top < 20) top = 20;
    if (left < 20) left = 20;

    if (isMobile) {
        height = "";
        width = "";
        initialHeight = "";
        initialWidth = "";
        top = "";
        left = "";
        showWindowFrame = false;
    }

    var restoreHeight = "";
    var restoreWidth = "";
    var restoreLeft = "";
    var restoreTop = "";
    var isMaximized = false;
    var isMinimized = false;

    var dialogBox = $j("<div/>", {
        id: id,
        height: initialHeight,
        width: initialWidth,
        'class': "axisDialogBox" + cssClass,
        css: { top: top, left: left }
    }).click(function (e) {
        if (!e) var e = window.event;
        e.cancelBubble = true;
        if (e.stopPropagation) e.stopPropagation();
    }).bind("closeDialog", function (e) {
        if (onClose) onClose(this);
        if (isMobile) {
            if (destroyOnClose) {
                $j("#" + id).fadeOut(300, function () {

                    if (modal) {
                        $j("#" + id + "ModalOverlay").remove();
                    } else {
                        $j("#" + id).remove();
                    }
                    if (onDestroy) onDestroy(this);
                });
            } else {
                $j("#" + id).fadeOut(300, function () {
                    if (modal) {
                        $j("#" + id + "ModalOverlay").hide();
                    } else {
                        $j("#" + id).hide();
                    }
                });
            }
            $j("body").css("overflow", "");
            $j("form").show();
            $j(window.parent.document).scrollTop(bounceHeight);
        } else {
            if (destroyOnClose) {
                if (modal) {
                    $j("#" + id + "ModalOverlay").remove();
                } else {
                    $j("#" + id).remove();
                }
                if (onDestroy) onDestroy(this);
            } else {
                if (modal) {
                    $j("#" + id + "ModalOverlay").hide();
                } else {
                    $j("#" + id).hide();
                }
            }
            $j("body").css("overflow", "");
        }
        $j(".axisDialogBox").attr("focused", "false");
    }).bind("setHTML", function (event, html) {
        dialogBox.find(".dialogContentWrapper").html(html);
    }).bind("setContentSize", function (event) {
        dialogBox.find(".dialogContentWrapper").css("height", "");
        var subtract = dialogBox.find(".dialogContent").outerHeight() - dialogBox.find(".dialogContent").height();
        subtract = dialogBox.find(".dialogContent").height() - subtract;
        if (subtract > 0) dialogBox.find(".dialogContentWrapper").height(subtract);
    }).bind("setTitleBar", function (event, newTitle) {
        $j(this).find(".dialogTitleBar span").html(newTitle);
        $j(this).parent().find(".dialogTitleBar span").html(newTitle);
        if (iconUrl !== "") {
            if ($j(this).find(".dialogTitleRow").find(".dialogIcon").length === 0) $j(this).find(".dialogTitleBar").before($j("<td/>").addClass("dialogIcon").append($j("<img/>").attr("src", iconUrl).attr("title", "This Page is Secured By SSL")));
        }
    }).bind("show", function (event) {
        if (modal) {
            $j("body").css("overflow", "hidden");
            $j("#" + id + "ModalOverlay").css({ top: $j(window).scrollTop() });
            if (isMaximized) {
                $j("#" + id + "ModalOverlay").width($j(window).width());
                $j("#" + id + "ModalOverlay").height($j(window).height());
            }
            $j("#" + id + "ModalOverlay").show();
        }
        $j("#" + id).show();
        $j("#" + id).trigger("reposition");
        if (onShow) onShow(this);
        dialogBox.focus();
    }).bind("destroyDialog", function (event) {
        if (modal) {
            $j("#" + id + "ModalOverlay").remove();
        } else {
            $j("#" + id).remove();
        }
        $j(".axisDialogBox").attr("focused", "false");
        if (onDestroy) onDestroy(this);
        $j("body").css("overflow", "");
    }).bind("setSize", function (event, size) {
        if (isMobile) return;
        if (isMaximized) {
        } else {
            if (size) {
                try {
                    if (size.height && size.height > 0) $j(this).height(parseInt(size.height));
                    if (size.width && size.width > 0) $j(this).width(parseInt(size.width));
                } catch (e) {
                    if (size.height && size.height > 0) $j(this).height(size.height);
                    if (size.width && size.width > 0) $j(this).width(size.width);
                }
            } else {
                $j(this).height(height);
                $j(this).width(width);
            }
            $j("#" + id).css('position','absolute');
            $j("#" + id + "iframe").height("1px");
            $j("#" + id + "iframe").height($j(dialogBox).find(".dialogContent").height());
            $j(this).trigger("reposition"); 
        }
        $j(this).trigger("setContentSize");
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width("");
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width($j("#" + id + "FrameTable").find(".dialogContent").width() - $j("#" + id + "FrameTable").find(".dialogActions ul").width() - $j("#" + id + "FrameTable").find(".dialogIcon").width() - 10);
        dialogBox.focus();
    }).bind("toggleMax", function (event) {
        if (isMobile) return;
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width(100);
        if (restoreHeight == "" && restoreWidth == "") {
            isMaximized = true;
            restoreHeight = $j(this).height();
            restoreWidth = $j(this).width();
            restoreTop = $j(this).offset().top;
            restoreLeft = $j(this).offset().left;
            $j(this).width($j(window).width());
            $j(this).height($j(window).height());
            $j("#" + id + "iframe").height("1px");
            $j("#" + id + "iframe").height($j(dialogBox).find(".dialogContent").height());
            var offsetWrapper = $j("#" + id + "ModalOverlay").offset();
            var offsetTop = (offsetWrapper) ? offsetWrapper.top : 0;
            $j(this).offset({ top: offsetTop, left: 0 });
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "overflow": "hidden" });
            }
            $j(this).find("#" + id + "maxToggle").removeClass("maximize");
            $j(this).find("#" + id + "maxToggle").addClass("maximized");
            $j(this).find("#" + id + "maxToggle a span").html("Restore");
            $j(this).find("#" + id + "maxToggle a").attr("title", "Restore");
            if (move) $j(this).draggable("disable");
            if (resize) $j(this).resizable("disable");
        } else {
            isMaximized = false;
            $j(this).width(restoreWidth);
            $j(this).height(restoreHeight);
            $j(this).offset({ top: restoreTop, left: restoreLeft });
            restoreHeight = "";
            restoreWidth = "";
            restoreLeft = "";
            restoreTop = "";
            $j("#" + id + "iframe").height("1px");
            $j("#" + id + "iframe").height($j(dialogBox).find(".dialogContent").height());
            $j(this).trigger("reposition");
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "overflow": "" });
            }
            $j(this).find("#" + id + "maxToggle").removeClass("maximized");
            $j(this).find("#" + id + "maxToggle").addClass("maximize");
            $j(this).find("#" + id + "maxToggle a span").html("Maximize");
            $j(this).find("#" + id + "maxToggle a").attr("title", "Maximize");
            if (move) $j(this).draggable("enable");
            if (resize) $j(this).resizable("enable");
        }
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width($j("#" + id + "FrameTable").find(".dialogContent").width() - $j("#" + id + "FrameTable").find(".dialogActions ul").width() - $j("#" + id + "FrameTable").find(".dialogIcon").width() - 10);
        $j(this).trigger("setContentSize");
        dialogBox.focus();
    }).bind("toggleMin", function (event) {
        if (isMobile) return;
        if (isMaximized) $j(this).trigger("toggleMax");
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width(100);
        if (restoreHeight == "" && restoreWidth == "") {
            isMinimized = true;
            restoreHeight = $j(this).height();
            restoreWidth = $j(this).width();
            restoreTop = $j(this).offset().top;
            restoreLeft = $j(this).offset().left;
            $j(this).width(300);
            $j(this).height($j(this).height() - $j("#" + id + "FrameTable").find(".dialogContent").height());
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "overflow": "hidden" });
            }
            $j(this).find("#" + id + "minToggle").removeClass("minimize");
            $j(this).find("#" + id + "minToggle").addClass("minimized");
            $j(this).find("#" + id + "minToggle a span").html("Restore");
            $j(this).find("#" + id + "minToggle a").attr("title", "Restore");
            $j("#" + id + "FrameTable").find(".dialogActions ul li").hide();
            $j(this).find("#" + id + "minToggle").show();
            $j("#" + id + "FrameTable").find(".dialogActions ul").width(23);
            $j("#" + id + "FrameTable").find(".dialogContent").hide();
            $j("#" + id + "FrameTable").attr("style", "padding-bottom: 0 !important;");
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "background-color": "transparent" });
                $j("#" + id + "ModalOverlay").css({ "z-index": "0" });
                $j("body").css("overflow", "");
            }
            if (resize) $j(this).resizable("disable");
        } else {
            isMinimized = false;
            $j(this).width(restoreWidth);
            $j(this).height(restoreHeight);
            $j(this).offset({ top: restoreTop, left: restoreLeft });
            restoreHeight = "";
            restoreWidth = "";
            restoreLeft = "";
            restoreTop = "";
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "overflow": "", opacity: 1 });
            }
            $j("#" + id).css({ opacity: 1 });
            $j(this).find("#" + id + "minToggle").removeClass("minimized");
            $j(this).find("#" + id + "minToggle").addClass("minimize");
            $j(this).find("#" + id + "minToggle a span").html("Minimize");
            $j(this).find("#" + id + "minToggle a").attr("title", "Minimize");
            $j("#" + id + "FrameTable").find(".dialogActions ul li").show();
            $j("#" + id + "FrameTable").find(".dialogActions ul").width($j("#" + id + "FrameTable").find(".dialogActions ul li").length * 23);
            $j("#" + id + "FrameTable").find(".dialogContent").show();
            $j("#" + id + "FrameTable").css("padding-bottom", "");
            if (modal) {
                $j("#" + id + "ModalOverlay").css({ "background-color": "" });
                $j("body").css("overflow", "hidden");
                $j("body").scrollTop($j("#" + id + "ModalOverlay").offset().top);
                //$j("#" + id + "ModalOverlay").css({ "z-index": "" });
            }
            if (resize) $j(this).resizable("enable");
        }
        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width($j("#" + id + "FrameTable").find(".dialogContent").width() - $j("#" + id + "FrameTable").find(".dialogActions ul").width() - $j("#" + id + "FrameTable").find(".dialogIcon").width() - 10);
        dialogBox.focus();
    }).bind("reposition", function () {
        if (isMobile) return;
        if (modal) {
            $j("body").css("overflow", "hidden");
            $j("#" + id + "ModalOverlay").css({ top: $j(window).scrollTop() });
            if (isMaximized) {
                $j("#" + id + "ModalOverlay").width($j(window).width());
                $j("#" + id + "ModalOverlay").height($j(window).height());
            }
            $j("#" + id + "ModalOverlay").show();
        }
        if (isMaximized) {
            $j(this).width($j(window).width());
            $j(this).height($j(window).height());
        } else {
            var left = ($j(window).width() / 2) - ($j(this).width() / 2);
            var top = ($j(window).height() / 2) - ($j(this).height() / 2);
            var offsetWrapper
            if (modal) {
                offsetWrapper = $j("#" + id + "ModalOverlay").offset();
            } else {
                offsetWrapper = { "top": $j(window).scrollTop(), "left": $j(window).scrollLeft() };
            }
            var offsetTop = (offsetWrapper) ? offsetWrapper.top : 0;
            top = offsetTop + top;
            if (top < 20 + offsetTop) top = 20 + offsetTop;
            if (left < 20) left = 20;
            $j(this).offset({ top: top, left: left });
            window.setTimeout("$j('#" + id + "ModalOverlay').scrollTop(0)", 10);
            window.setTimeout("$j('#" + id + "ModalOverlay').scrollTop(0)", 100);
        }
        if ($j("#" + id + "ModalOverlay").height() < dialogBox.height() + 20) {
            $j("#" + id + "ModalOverlay").find(".modalSpacerBox").css("padding-top", dialogBox.height() + 20);
        }
        dialogBox.focus();
    }).bind("focus", function () {
        $j(".axisDialogBox").attr("focused", "false");
        dialogBox.attr("focused", "true");
        //$j(".axisDialogBox").css("z-index", "");
        if (modal) {
            $j("#" + id + "ModalOverlay").css("z-index", zIndex);
            dialogBox.css("z-index", zIndex + 1);
            zIndex = zIndex + 1;
        } else {
            dialogBox.css("z-index", zIndex);
            zIndex = zIndex + 1;
        }
    });

    if ($j.browser.msie) {
        if (document.compatMode == "BackCompat") {  
	    dialogBox.addClass("isIEQuirks");
        } else { 
            dialogBox.addClass("isIE");
        }
    }

    var contentRow = $j("<tr/>");
    var contentCell = $j("<td/>", {
        colspan: (iconUrl !== "") ? 3 : 2,
        'class': "dialogContent"
    });
    contentCell.appendTo(contentRow);

    var frame;
    var frameIsLoaded = false;

    if (content != "") {
        $j("<div/>").addClass("dialogContentWrapper").html(content).appendTo(contentCell);
        if (maximized) $j("#" + id).trigger("toggleMax");
    } else if (href != "") {
	var bounceHeight = $j(window.parent.document).scrollTop();
	frame = $j("<iframe />", {
	    width: "100%",
	    height: "100%",
	    name: id + "iframe",
	    id: id + "iframe",
	    scrolling: (disableIframeScrolling) ? "no" : "auto",
	    frameborder: 0,
	    css: { "z-index": "99999", "display": (showLoader) ? "none" : "block" },
	    src: href
	}).attr("axisdialog", "yes").load(function () {
	    if (frameIsLoaded) return;
	    var frameWidth = $j(this).width();
	    if (showLoader) {
	        $j("#" + id).trigger("setSize");
	        $j(this).show();
	        frameWidth = $j(this).width()
	        if (title) $j("#" + id).trigger("setTitleBar", title);
	        $j("#" + id).find(".dialogContentLoader").hide();
	    }
	    window.setTimeout('$j("#' + id + 'iframe").focus()', 0);
	    if (isMobile) {
	        window.scrollTo(0, 0);
	        $j("#" + id).show();
	        $j(".dialogContentLoader").remove();
	        if ($j(".dialogContentWrapper").outerHeight() + $j(".dialogTitleBar").outerHeight() < $j(window).height()) dialogBox.height($j('#' + id + 'iframe').contents().height());
	        setInterval(function () { if ($j(".dialogContentWrapper").outerHeight() + $j(".dialogTitleBar").outerHeight() < $j(window).height()) dialogBox.height($j('#' + id + 'iframe').contents().height()); }, 300);
	    } else {
	        $j("#" + id + "FrameTable").find(".dialogActions ul").show();
	        $j("#" + id + "FrameTable").find(".dialogTitleBar span").width(frameWidth - $j("#" + id + "FrameTable").find(".dialogActions ul").width() - $j("#" + id + "FrameTable").find(".dialogIcon").width() - 10);
	        if (maximized) $j("#" + id).trigger("toggleMax");
	    }
	    $j(this.contentWindow).keydown(function (e) {
	        if (e.keyCode == 27) parent.setTimeout("doKeyPress(" + e.keyCode + ");", 10);
	    });
	    if (onFrameLoad) onFrameLoad(this, dialogBox);
	    frameIsLoaded = true;
	    if (isMobile) { $j(window.parent.document).scrollTop(0); } else { $j(window.parent.document).scrollTop(bounceHeight); }
	}).focus(function () {
	    $j(".axisDialogBox").attr("focused", "false");
	    dialogBox.attr("focused", "true");
	});
    }

    if (showWindowFrame) {
        if (frame) {
            frame.appendTo(contentCell);
            if (showLoader) {
                contentCell.append("<div class=\"dialogContentLoader\"><div class=\"dialogContentLoaderImg\"></div></div>");
            }
        }
        var frameClass = "dialogFrameTable";
        if (!showTitleBar) frameClass = frameClass + " noTitlebar";
        var frameTable = $j("<table/>", {
            id: id + "FrameTable",
            'class': frameClass
        });
        if (showTitleBar) {
            var actions = "";
            var actionCount = 0;
            if (minimize) {
                actions = actions + "<li id=\"" + id + "minToggle\" class=\"minimize\"><a title=\"Minimize\" onclick=\"javascript:toggleAxisDialogMin('" + id + "');\"><span>Minimize</span></a></li>";
                actionCount++;
            }
            if (maximize) {
                actions = actions + "<li id=\"" + id + "maxToggle\" class=\"maximize\"><a title=\"Maximize\" onclick=\"javascript:toggleAxisDialogMax('" + id + "');\"><span>Maximize</span></a></li>";
                actionCount++;
            }
            if (showCloseX) {
                actions = actions + "<li class=\"close\"><a title=\"Close\" onclick=\"javascript:hideAxisDialog('" + id + "');\"><span>Close</span></a></li>";
                actionCount++;
            }
            if (actions != "") actions = "<ul style=\"width: " + (actionCount * 23) + "px\">" + actions + "</ul>";
            frameTable.append("<tr class=\"dialogTitleRow\"><td class=\"dialogTitleBar\"><span unselectable=\"on\">" + ((frame && showLoader) ? "Loading..." : title) + "</span></td><td class=\"dialogActions\">" + actions + "</td></tr>");
            if ($j.browser.msie && document.compatMode == "BackCompat") { //hack ie frame
                frameTable.find(".dialogTitleRow").append("<td style=\"width: 0px;\" rowspan=\"3\"></td>");
                frameTable.find(".dialogTitleRow").prepend("<td style=\"width: 0px;\" rowspan=\"3\"></td>");
            }
            if (showLoader && content == "") frameTable.find(".dialogActions ul").hide();
        }
        contentRow.appendTo(frameTable);
        if (showTitleBar && $j.browser.msie && document.compatMode == "BackCompat") {
            if (iconUrl !== "") {
                frameTable.append("<tr><td colspan=\"3\"></td></tr>");
            } else {			 
                frameTable.append("<tr><td colspan=\"2\"></td></tr>");
            }
        }
        frameTable.appendTo(dialogBox);
    } else {
        if (content != "") {
            dialogBox.html("<div class=\"dialogContentWrapper\">" + content + "</div>");
        } else if (href != "") {
            frame.appendTo(dialogBox);
        }
    }
    if (move) dialogBox.draggable({
        containment: "parent",
        opacity: 0.6,
        handle: ".dialogTitleBar",
        stop: function () {
            $j(this).unbind("reposition");
            $j(this).focus();
            restoreLeft = $j(this).offset().left;
            restoreTop = $j(this).offset().top;
        },
        start: function () { $j(this).focus(); }
    }).css("position", "absolute");
    if (maximize) {
        dialogBox.find(".dialogTitleBar").dblclick(function () {
            toggleAxisDialogMax(id);
        });
    }
    if (resize) dialogBox.resizable({
        containment: "parent",
        handles: "n, e, s, w, ne, se, sw, nw",
        minHeight: resizeMinHeight,
        minWidth: resizeMinWidth,
        start: function () {
            $j(this).focus();
            try {
                $j("#" + id + "iframe").hide();
            } catch (e) { }
        },
        stop: function () {
            $j(this).focus();
            $j(this).unbind("reposition");
            $j("#" + id).trigger("setContentSize");
            try {
                $j("#" + id + "iframe").height("1px");
                $j("#" + id + "iframe").height($j(dialogBox).find(".dialogContent").height());
                $j("#" + id + "iframe").show();
            } catch (e) { }
        }
    });

    dialogBox.attr("escapeable", escapeToClose).click(function () {
        dialogBox.focus();
    });

    if (modal) {
        var modalBox = $j("<div/>", {
            id: id + "ModalOverlay",
            'class': "modalDialogOverlay" + cssClass,
            css: { top: $j(window).scrollTop() }
        }).click(function (e) {
            if (modalClickClosesDialog && !isMinimized) hideAxisDialog(id);
        });

        if ($j.browser.msie) {
            if (document.compatMode == "BackCompat") { 
	        modalBox.addClass("isIEQuirks");
            } else {
                modalBox.addClass("isIE");
            }
        }  

        var spacerBox = $j("<div/>", {
            'class': "modalSpacerBox"
        });
        dialogBox.appendTo(modalBox);
        spacerBox.appendTo(modalBox);

        if (isMobile) {
            modalBox.prependTo("body");
        } else {
            modalBox.prependTo("form");
        }
        $j("body").css("overflow", "hidden");
    } else {
        if (isMobile) {
            dialogBox.prependTo("body");
        } else {
            dialogBox.prependTo("form");
        }
    }

    $j(window).resize(function () {
        if (pinToCenterOnResize || isMobile) $j(dialogBox).trigger("reposition");
        if ($j("#" + id + "ModalOverlay").height() < dialogBox.height() + 20) {
            $j("#" + id + "ModalOverlay").find(".modalSpacerBox").css("padding-top", dialogBox.height() + 20);
        }
    });

    if (isMobile) {
        dialogBox.hide();
        if (showTitleBar) {
            var actions = "";
            var actionCount = 0;
            if (showCloseX) {
                actions = actions + "<li class=\"close\"><a title=\"Close\" onclick=\"javascript:hideAxisDialog('" + id + "');\"><span>Close</span></a></li>";
                actionCount++;
            }
            if (actions != "") actions = "<ul style=\"width: " + (actionCount * 23) + "px\">" + actions + "</ul>";
            dialogBox.prepend("<div class=\"dialogTitleBar\"><span unselectable=\"on\">" + ((frame && showLoader) ? "Loading..." : title) + "</span><div class=\"dialogActions\">" + actions + "</div></div>")
        }
        dialogBox.height($j(".dialogContentWrapper").outerHeight() + $j(".dialogTitleBar").outerHeight());
        if ($j(".dialogContentWrapper").outerHeight() + $j(".dialogTitleBar").outerHeight() < $j(window).height()) dialogBox.height($j(window).height());
        //$j("body").css("overflow", "hidden");
        if (frame && showLoader) {
            $j("body").append("<div class=\"dialogContentLoader\"><div class=\"dialogContentLoaderImg\"></div></div>");
        } else {
            dialogBox.show();
        }
        $j("form").hide();
    } else {
        dialogBox.trigger("setContentSize");
    }

    if ($j("#" + id + "ModalOverlay").height() < dialogBox.height() + 20) {
        $j("#" + id + "ModalOverlay").find(".modalSpacerBox").css("padding-top", dialogBox.height() + 20);
    }
    try {
        if (($j.browser.msie || !!navigator.userAgent.match(/Trident\/7\./)) && content != "") {
            // ie inputbox fix
            $j('.dialogContentWrapper').find('input').click(function () {
                ieInputBoxFix = $j(this);
                setTimeout(function () { $j(ieInputBoxFix).focus(); }, 100);
            });
        } 
    } catch (e) { }


    if (onShow) onShow(dialogBox);

    dialogBox.focus();

    return dialogBox;
}
function hideAxisDialog(dialogId) {
    $j("#" + dialogId).trigger("closeDialog");
}
function setAxisDialogTitle(dialogId, newTitle) {
    $j("#" + dialogId).trigger("setTitleBar", newTitle);
}
function toggleAxisDialogMax(dialogId) {
    $j("#" + dialogId).trigger("toggleMax");
}
function toggleAxisDialogMin(dialogId) {
    $j("#" + dialogId).trigger("toggleMin");
}
function amIAxisDialog() {
    if (window.frameElement) {
        var frame = $j(window.frameElement);
        if (frame.attr("axisdialog") == "yes") {
            return true;
        }
    }
    return false;
}
function getActiveAxisDialog() {
    var dialog;
    $j.each($j(".axisDialogBox"), function (key, Dialog) {
        if ($j(this).attr("focused") == "true") {
            dialog = $j(this);
        }
    });
    return dialog;
}
$j(document).load(function () {
    $j(window).keydown(function (e) {
        doKeyPress(e.keyCode);
    });
});
function doKeyPress(keyCode) {
    if (keyCode == 27) {
        var dialog = getActiveAxisDialog();
        if (dialog && dialog.attr("escapeable") == "true") dialog.trigger("closeDialog");
    }
}